import fileinput
import re

badChars = re.compile('([#\*=+@]|[^\x00-\x7F])')
rhymeMatch = re.compile('(\d\d\d\d\d\d\d\d\d+),(\d\d\d\d\d\d\d\d\d+)\s([^\/]+)\/([^\/]+)$')
nonWords = re.compile('[^\w]')

rhymes = []
quads = []
i = 0

for line in fileinput.input():
	# disabled badChars test
	if (True or not badChars.search(line)):
		m = rhymeMatch.search(line)
		if m is not None:
			id1 = m.group(1)
			id2 = m.group(2)
			line1 = m.group(3).strip()
			line2 = m.group(4).strip()
			
			line1test = nonWords.sub('', line1)
			line2test = nonWords.sub('', line2)
			
			if (len(line1test) > 20 and len(line2test) > 20):
				i = i + 1
				rhymes.append([id1, line1, id2, line2])
				if (i % 2):
					quad = [[id1, line1, id2, line2]]
				else:
					quad.append([id1, line1, id2, line2])
					quads.append(quad)
					



#state = 'title'
#chapter = 1
#chapterRhyme = None
state='verse'
verse=1





def int_to_roman(input):
   if type(input) != type(1):
      raise TypeError, "expected integer, got %s" % type(input)
   if not 0 < input< 4000:
      raise ValueError, "Argument must be between 1 and 3999"
   result = ""
   nums = ('M', 'D', 'C', 'L', 'X', 'V', 'I')
   ints = (1000, 500, 100, 50,  10,  5,   1)
   places = [0,] * len(nums)
   # count how many times each int we have
   for i in range(len(ints)):
      value = ints[i]
      count = input / value
      places[i] = count
      if count: input -= count * value
   # Format the output string
   for i in range(len(places)):
      if places[i] < 4:
         result += nums[i] * places[i]
      else:
         # 4 repetitions means we're trying to represent 4 or 9
         # of something.
         if places[i -1] == 0:
            # it's a 4.
            result += nums[i] + nums[i -1]
         else:
            # it's a 9.
            # 'the next' character is 2 away from here, not 1;
            # otherwise we'd get 'IV' when we want 'IX'.
            # We'll also need to delete the previous character,
            # or we'll get stuff like 'VIX' when we want 'IX'.
            result = result[:-1] + nums[i] + nums[i -2]
   return result
   
   
   

for quad in quads:
	if (state == 'title'):
		print "# " + quad[0][1]
		print "*A novel by @pentametron*"
		state = 'chapter'
	elif (state == 'chapter'):
		print
		print
		# print "## Chapter " + int_to_roman(chapter)
		chapter = chapter + 1
		if (chapterRhyme):
			# print "*" + chapterRhyme + "*"
			chapterRhyme = None
		else:
			# print "*" + quad[0][1] + "*"
			chapterRhyme = quad[0][3]
		print
		state = "verse"
		verse = 1
	elif (state == 'verse'):
		if (verse < 4):
			print "<p>"+ quad[0][1] + "<br/>"
			print quad[1][1] + "<br/>"
			print quad[0][3] + "<br/>"
			print quad[1][3] + "</p>"
			print
			verse = verse + 1
		else:
			print "<p>" + quad[0][1] + "<br/>"
			print quad[0][3] + "</p>"
			print "<p>&nbsp;</p>"
			print "<p>&nbsp;</p>"
			#state="chapter"
			state="verse"
			verse = 1
			
			
		
		
		
